<?php
declare(strict_types=1);

require_once __DIR__ . '/core.php';

header('Content-Type: application/json; charset=utf-8');

$id = trim($_GET['id'] ?? '');
if ($id === '') {
    http_response_code(400);
    echo json_encode(['error' => 'شناسه پیشرفت ارسال نشده است.']);
    exit;
}

$file = PROGRESS_PATH . '/' . sanitizeSlug($id) . '.json';
if (!file_exists($file)) {
    http_response_code(404);
    echo json_encode(['error' => 'هیچ وضعیت فعالی برای این شناسه پیدا نشد.']);
    exit;
}

$data = json_decode(file_get_contents($file), true);
if (!$data) {
    http_response_code(500);
    echo json_encode(['error' => '❌ خطا در خواندن وضعیت پیشرفت.']);
    exit;
}

// محاسبه سرعت تقریبی (KB/s)
$downloaded = (int)($data['downloaded'] ?? 0);
$total      = (int)($data['total'] ?? 0);
$updatedAt  = (int)($data['updated_at'] ?? time());

$elapsed = max(1, time() - $updatedAt);
$speed   = $elapsed > 0 ? round(($downloaded / 1024) / $elapsed, 2) : 0; // KB/s

echo json_encode([
    'downloaded'     => $downloaded,
    'total'          => $total,
    'percent'        => $total > 0 ? round(($downloaded / $total) * 100, 2) : 0,
    'speed'          => $speed,
    'downloaded_str' => formatBytes($downloaded),
    'total_str'      => formatBytes($total),
    'updated_at'     => date('c', $updatedAt)
]);